####################################################
### code chunk number : Simulations: Marginal density, mu = 0, alpha = 3, beta = 1
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
set.seed(1)
mu = 0                ## hyperparameter
alpha = 3             ## hyperparameter
beta = 1              ## hyperparameter     

x = seq(-5, 5, by = 0.01)
md = Marginal_density_mu_alpha_beta(x, mu, alpha, beta)

dev.new()
col = 1:1
lty = 1:1
xlim = range(x); xlim
ylim = c(0, 0.8); ylim
plot(x, md, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md,  lty = lty[1], col = col[1], lwd = 4)
# title(Title)
leg.txt = "mu = 0, alpha = 3, beta = 1"
legend("topright", legend = leg.txt, lty = lty, col = col)
# savePlot(filename = paste("figure/md_x", sep=""), type = c("pdf"))


####################################################
### code chunk number : Simulations: Marginal density, mu changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = c(-2, -1, 0, 1, 2) ## hyperparameter
alpha = 3               ## hyperparameter
beta = 1                ## hyperparameter

x = seq(-5, 5, by = 0.01)
md1 = Marginal_density_mu_alpha_beta(x, mu = mu[1], alpha, beta); 
md2 = Marginal_density_mu_alpha_beta(x, mu = mu[2], alpha, beta);
md3 = Marginal_density_mu_alpha_beta(x, mu = mu[3], alpha, beta); 
md4 = Marginal_density_mu_alpha_beta(x, mu = mu[4], alpha, beta); 
md5 = Marginal_density_mu_alpha_beta(x, mu = mu[5], alpha, beta); 

dev.new()
col = 1:5
lty = 1:5
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4, md5); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 4)
lines(x, md5,  lty = lty[5], col = col[5], lwd = 4)
# title(Title)
leg.txt = c(
expression(paste(mu, " = -2", sep = "")),
expression(paste(mu, " = -1", sep = "")),
expression(paste(mu, " = 0", sep = "")),
expression(paste(mu, " = 1", sep = "")),
expression(paste(mu, " = 2", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/N-IG_md_x_mu_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/N-IG_md_x_mu_changes", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal density, alpha changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0                         ## hyperparameter
alpha = c(0.75, 1.5, 3, 6, 12)  ## hyperparameter
beta = 1                       ## hyperparameter

x = seq(-5, 5, by = 0.01)
md1 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[1], beta); 
md2 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[2], beta); 
md3 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[3], beta);  
md4 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[4], beta);  
md5 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[5], beta);   

dev.new()
col = 1:5
lty = 1:5
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4, md5); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 4)
lines(x, md5,  lty = lty[5], col = col[5], lwd = 4)
# title(Title)
leg.txt = c(
expression(paste(alpha, " = 0.75", sep = "")),
expression(paste(alpha, " = 1.5", sep = "")),
expression(paste(alpha, " = 3", sep = "")),
expression(paste(alpha, " = 6", sep = "")),
expression(paste(alpha, " = 12", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/N-IG_md_x_alpha_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/N-IG_md_x_alpha_changes", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal density, beta changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0                       ## hyperparameter
alpha = 3                    ## hyperparameter
beta = c(0.25, 0.5, 1, 2, 4) ## hyperparameter

x = seq(-5, 5, by = 0.01)
md1 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[1]); 
md2 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[2]);  
md3 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[3]);  
md4 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[4]);  
md5 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[5]);   

dev.new()
col = 1:5
lty = 1:5
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4, md5); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 4)
lines(x, md5,  lty = lty[5], col = col[5], lwd = 4)
# title(Title)
leg.txt = c(
expression(paste(beta, " = 0.25", sep = "")),
expression(paste(beta, " = 0.5", sep = "")),
expression(paste(beta, " = 1", sep = "")),
expression(paste(beta, " = 2", sep = "")),
expression(paste(beta, " = 4", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/N-IG_md_x_beta_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/N-IG_md_x_beta_changes", sep=""), type = c("jpg"))

